/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jclass.beans.GroupPanel;
import jclass.table3.AppWrapper;
import jclass.table3.JCCellRange;
import jclass.table3.PropertyCellRenderer;
import jclass.table3.SeriesEditor;
import jclass.table3.bean.AppearanceCellRenderer;
import jclass.table3.bean.ColorDialog;
import jclass.util.JCUtilConverter;

public class AppearanceEditor
extends SeriesEditor
implements ActionListener,
ItemListener {
    private Choice choiceName;
    private Choice choiceStyle;
    private Choice choiceSize;
    private Choice choiceFG;
    private Choice choiceBG;
    private Button buttonFG;
    private Button buttonBG;
    Color colorCustomFG;
    Color colorCustomBG;
    private String[] fonts;
    private static final String[] style_names = new String[]{"plain", "bold", "italic"};
    private static final int[] styles;
    private static final int[] point_sizes;
    static String[] color_names;

    public AppearanceEditor() {
    }

    public AppearanceEditor(int n) {
        super(n);
    }

    public void setValue(Object object) {
        if (object == null) {
            object = new AppWrapper("(all all black)", "(all all lightGray)", "(all all Dialog-PLAIN-10)");
        }
        this.tableView.setAppearance((AppWrapper)object);
        super.setValue(object);
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange != null) {
            this.updateFont(jCCellRange);
            this.updateColor(jCCellRange);
        }
    }

    public Object getValue() {
        return this.tableView.getAppearance();
    }

    public String getAsText() {
        return this.getStringValue(this.nl);
    }

    public String getJavaInitializationString() {
        return "new jclass.table3.AppWrapper(" + this.getStringValue(",\n      ") + ")";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceName) || object.equals(this.choiceStyle) || object.equals(this.choiceSize)) {
            this.setFont();
        }
        if (object.equals(this.choiceFG) || object.equals(this.choiceBG)) {
            this.setColor(object.equals(this.choiceFG));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonFG) || object.equals(this.buttonBG)) {
            this.openColorDialog(object.equals(this.buttonFG));
        }
    }

    protected PropertyCellRenderer getPropertyCellRenderer() {
        return new AppearanceCellRenderer(this);
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateFont(jCCellRange);
        this.updateColor(jCCellRange);
        this.support.firePropertyChange("appearance", null, this.getValue());
    }

    protected Component makePropertyPanel() {
        this.choiceFG = new Choice();
        this.choiceBG = new Choice();
        int n = 0;
        while (n < color_names.length) {
            this.choiceFG.addItem(color_names[n]);
            this.choiceBG.addItem(color_names[n]);
            ++n;
        }
        this.buttonFG = new Button("...");
        this.buttonBG = new Button("...");
        GroupPanel groupPanel = new GroupPanel("Color");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new Label("Foreground"), gridBagConstraints);
        groupPanel.add((Component)this.choiceFG, gridBagConstraints);
        groupPanel.add((Component)this.buttonFG, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new Label("Background"), gridBagConstraints);
        groupPanel.add((Component)this.choiceBG, gridBagConstraints);
        groupPanel.add((Component)this.buttonBG, gridBagConstraints);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.fonts = toolkit.getFontList();
        this.choiceName = new Choice();
        int n2 = 0;
        while (n2 < this.fonts.length) {
            this.choiceName.addItem(this.fonts[n2]);
            ++n2;
        }
        this.choiceStyle = new Choice();
        int n3 = 0;
        while (n3 < style_names.length) {
            this.choiceStyle.addItem(style_names[n3]);
            ++n3;
        }
        this.choiceSize = new Choice();
        int n4 = 0;
        while (n4 < point_sizes.length) {
            this.choiceSize.addItem(String.valueOf(point_sizes[n4]));
            ++n4;
        }
        GroupPanel groupPanel2 = new GroupPanel("Font");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel2.add((Component)new Label("Name"), gridBagConstraints);
        groupPanel2.add((Component)this.choiceName, gridBagConstraints);
        groupPanel2.add((Component)new Label("Style"), gridBagConstraints);
        groupPanel2.add((Component)this.choiceStyle, gridBagConstraints);
        groupPanel2.add((Component)new Label("Size"), gridBagConstraints);
        groupPanel2.add((Component)this.choiceSize, gridBagConstraints);
        Panel panel = new Panel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(6);
        panel.setLayout(borderLayout);
        panel.add("West", groupPanel);
        panel.add("Center", groupPanel2);
        this.choiceName.addItemListener(this);
        this.choiceStyle.addItemListener(this);
        this.choiceSize.addItemListener(this);
        this.buttonFG.addActionListener(this);
        this.buttonBG.addActionListener(this);
        this.choiceFG.addItemListener(this);
        this.choiceBG.addItemListener(this);
        return panel;
    }

    protected void updateFont(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return;
        }
        Font font = this.tableView.getFont(jCCellRange.start_row, jCCellRange.start_column);
        if (font != null) {
            this.choiceName.select(font.getName());
            switch (font.getStyle()) {
                case 0: {
                    this.choiceStyle.select("plain");
                    break;
                }
                case 1: {
                    this.choiceStyle.select("bold");
                    break;
                }
                case 2: {
                    this.choiceStyle.select("italic");
                    break;
                }
            }
            this.choiceSize.select(String.valueOf(font.getSize()));
        }
    }

    protected void updateColor(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return;
        }
        Color color = this.tableView.getForeground(jCCellRange.start_row, jCCellRange.start_column);
        this.choiceFG.select(this.getColorName(color));
        this.colorCustomFG = color;
        color = this.tableView.getBackground(jCCellRange.start_row, jCCellRange.start_column);
        this.choiceBG.select(this.getColorName(color));
        this.colorCustomBG = color;
    }

    Color getColor(boolean bl) {
        if (bl) {
            return this.colorCustomFG;
        }
        return this.colorCustomBG;
    }

    void selectColor(Color color, boolean bl) {
        if (color != null) {
            this.setColor(color, bl);
        }
    }

    private String getStringValue(String string) {
        return "\"" + this.tableView.fromSeries(10) + "\"" + string + "\"" + this.tableView.fromSeries(1) + "\"" + string + "\"" + this.tableView.fromSeries(9) + "\"";
    }

    private void setFont() {
        Font font;
        JCCellRange jCCellRange = this.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        String string = this.choiceName.getSelectedItem();
        int n = styles[this.choiceStyle.getSelectedIndex()];
        int n2 = point_sizes[this.choiceSize.getSelectedIndex()];
        try {
            font = new Font(string, n, n2);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create font " + string + "-" + style_names[n] + "-" + n2);
            return;
        }
        this.tableView.setFont(jCCellRange, font);
        this.support.firePropertyChange("appearance", null, this.getValue());
    }

    private void openColorDialog(boolean bl) {
        if (this.getSelectedRange() == null) {
            return;
        }
        ColorDialog colorDialog = new ColorDialog(this, bl);
        colorDialog.show();
    }

    private void setColor(Color color, boolean bl) {
        if (color != null) {
            JCCellRange jCCellRange = this.getSelectedRange();
            if (bl) {
                this.tableView.setForeground(jCCellRange, color);
            } else {
                this.tableView.setBackground(jCCellRange, color);
            }
            this.support.firePropertyChange("appearance", null, this.getValue());
        }
    }

    private void setColor(boolean bl) {
        if (this.getSelectedRange() == null) {
            return;
        }
        Choice choice = bl ? this.choiceFG : this.choiceBG;
        Color color = JCUtilConverter.toColor(choice.getSelectedItem());
        this.setColor(color, bl);
    }

    private String getColorName(Color color) {
        if (color == null) {
            return "Black";
        }
        if (color.equals(Color.black)) {
            return "Black";
        }
        if (color.equals(Color.blue)) {
            return "Blue";
        }
        if (color.equals(Color.cyan)) {
            return "Cyan";
        }
        if (color.equals(Color.darkGray)) {
            return "DarkGray";
        }
        if (color.equals(Color.gray)) {
            return "Gray";
        }
        if (color.equals(Color.green)) {
            return "Green";
        }
        if (color.equals(JCUtilConverter.lightBlue)) {
            return "LightBlue";
        }
        if (color.equals(Color.lightGray)) {
            return "LightGray";
        }
        if (color.equals(Color.magenta)) {
            return "Magenta";
        }
        if (color.equals(Color.orange)) {
            return "Orange";
        }
        if (color.equals(Color.pink)) {
            return "Pink";
        }
        if (color.equals(Color.red)) {
            return "Red";
        }
        if (color.equals(Color.white)) {
            return "White";
        }
        if (color.equals(Color.yellow)) {
            return "Yellow";
        }
        return "Custom";
    }

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        styles = nArray;
        point_sizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 28, 30, 32, 36, 48};
        color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White", "Custom"};
    }
}

